VERSION 5.00
Object = "{65E121D4-0C60-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCHRT20.OCX"
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "RICHTX32.OCX"
Begin VB.Form Form1 
   AutoRedraw      =   -1  'True
   Caption         =   "Form1"
   ClientHeight    =   8670
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   9345
   LinkTopic       =   "Form1"
   ScaleHeight     =   8670
   ScaleWidth      =   9345
   StartUpPosition =   3  'Windows Default
   Begin VB.CheckBox Check3 
      Caption         =   "Check2"
      Height          =   375
      Left            =   0
      TabIndex        =   20
      Top             =   0
      Width           =   255
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Run"
      Height          =   1335
      Left            =   4920
      TabIndex        =   18
      Top             =   5160
      Width           =   1335
   End
   Begin VB.TextBox TextYMin 
      Height          =   285
      Left            =   480
      TabIndex        =   14
      Tag             =   "0"
      Text            =   "0"
      Top             =   3360
      Width           =   375
   End
   Begin VB.TextBox TextYMax 
      Height          =   285
      Left            =   480
      TabIndex        =   13
      Tag             =   "300"
      Text            =   "300"
      Top             =   1080
      Width           =   375
   End
   Begin VB.Frame Frame5 
      Caption         =   "Number of Points"
      Height          =   2295
      Left            =   240
      TabIndex        =   11
      Top             =   4680
      Width           =   1455
      Begin VB.ListBox ListPoints 
         Height          =   1620
         ItemData        =   "Form1.frx":0000
         Left            =   240
         List            =   "Form1.frx":0027
         TabIndex        =   12
         Top             =   360
         Width           =   975
      End
   End
   Begin VB.Frame Frame4 
      Caption         =   "TimeScale"
      Height          =   2295
      Left            =   1680
      TabIndex        =   8
      Top             =   4680
      Width           =   1215
      Begin VB.ListBox ListTimeScale 
         Height          =   1815
         ItemData        =   "Form1.frx":0055
         Left            =   120
         List            =   "Form1.frx":007D
         TabIndex        =   10
         Top             =   240
         Width           =   735
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Trigger"
      Height          =   2295
      Left            =   2880
      TabIndex        =   7
      Top             =   4680
      Width           =   1695
      Begin VB.ListBox ListTrigger 
         Height          =   1620
         ItemData        =   "Form1.frx":00D1
         Left            =   240
         List            =   "Form1.frx":00DB
         TabIndex        =   9
         Top             =   360
         Width           =   1335
      End
   End
   Begin VB.CommandButton Command2 
      Caption         =   "Run"
      Height          =   1335
      Left            =   7800
      TabIndex        =   3
      Top             =   5160
      Width           =   1215
   End
   Begin VB.ListBox ListChannel 
      Height          =   1620
      ItemData        =   "Form1.frx":00F5
      Left            =   6720
      List            =   "Form1.frx":0111
      TabIndex        =   2
      Top             =   5040
      Width           =   615
   End
   Begin RichTextLib.RichTextBox RichTextBox1 
      Height          =   6855
      Left            =   9360
      TabIndex        =   1
      Top             =   120
      Width           =   3255
      _ExtentX        =   5741
      _ExtentY        =   12091
      _Version        =   393217
      Enabled         =   -1  'True
      ScrollBars      =   3
      TextRTF         =   $"Form1.frx":013D
   End
   Begin MSChart20Lib.MSChart MSChart1 
      DragMode        =   1  'Automatic
      Height          =   4365
      Left            =   240
      OleObjectBlob   =   "Form1.frx":01BF
      TabIndex        =   0
      Top             =   240
      Visible         =   0   'False
      Width           =   9000
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   360
      Top             =   8880
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
      BaudRate        =   115200
   End
   Begin VB.Frame Frame1 
      Caption         =   "Digital Analyzer"
      Height          =   2295
      Left            =   7560
      TabIndex        =   4
      Top             =   4680
      Width           =   1695
   End
   Begin VB.Frame Frame2 
      Caption         =   "Oscilloscope"
      Height          =   2295
      Left            =   4560
      TabIndex        =   5
      Top             =   4680
      Width           =   3015
      Begin VB.Label Label1 
         Caption         =   "Channel "
         Height          =   255
         Left            =   2160
         TabIndex        =   6
         Top             =   120
         Width           =   975
      End
   End
   Begin VB.Frame Frame6 
      Caption         =   "Set Digital Outputs"
      Height          =   1455
      Left            =   240
      TabIndex        =   15
      Top             =   7080
      Width           =   9015
      Begin VB.CommandButton Command3 
         Caption         =   "Run"
         Height          =   975
         Left            =   5280
         TabIndex        =   16
         Top             =   360
         Width           =   3015
      End
      Begin VB.Frame Frame7 
         Caption         =   "Port T (bits)"
         Height          =   1095
         Left            =   720
         TabIndex        =   17
         Top             =   240
         Width           =   4335
         Begin VB.CheckBox Check12 
            Caption         =   "2"
            Height          =   400
            Left            =   2760
            TabIndex        =   27
            Tag             =   "4"
            Top             =   360
            Width           =   400
         End
         Begin VB.CheckBox Check10 
            Caption         =   "0"
            Height          =   400
            Left            =   3720
            TabIndex        =   26
            Tag             =   "1"
            Top             =   360
            Width           =   400
         End
         Begin VB.CheckBox Check13 
            Caption         =   "3"
            Height          =   400
            Left            =   2280
            TabIndex        =   25
            Tag             =   "8"
            Top             =   360
            Width           =   400
         End
         Begin VB.CheckBox Check11 
            Caption         =   "1"
            Height          =   400
            Left            =   3240
            TabIndex        =   24
            Tag             =   "2"
            Top             =   360
            Width           =   400
         End
         Begin VB.CheckBox Check14 
            Caption         =   "4"
            Height          =   400
            Left            =   1680
            TabIndex        =   23
            Tag             =   "16"
            Top             =   360
            Width           =   400
         End
         Begin VB.CheckBox Check15 
            Caption         =   "5"
            Height          =   400
            Left            =   1200
            TabIndex        =   22
            Tag             =   "32"
            Top             =   360
            Width           =   400
         End
         Begin VB.CheckBox Check16 
            Caption         =   "6"
            Height          =   400
            Left            =   720
            TabIndex        =   21
            Tag             =   "64"
            Top             =   360
            Width           =   400
         End
         Begin VB.CheckBox Check17 
            Caption         =   "7"
            Height          =   400
            Left            =   240
            TabIndex        =   19
            Tag             =   "128"
            Top             =   360
            Width           =   375
         End
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)



'Perform Scope function
Private Sub Command1_Click()
   UpdateChart ("0")
   TextYMax.Text = TextYMax.Tag
   TextYMin.Text = TextYMin.Tag
   MSChart1.Plot.Axis(VtChAxisIdY).ValueScale.MajorDivision = 6
   MSChart1.Plot.Axis(VtChAxisIdY).ValueScale.MinorDivision = 2

End Sub
'Perform digital analyzer function
Private Sub Command2_Click()
   UpdateChart ("1")
   If TextYMax.Text <> 1 Then
      TextYMax.Tag = TextYMax.Text
      TextYMax.Text = 1
   End If
   If TextYMin.Text <> 0 Then
      TextYMin.Tag = TextYMin.Text
      TextYMin.Text = 0
   End If
   MSChart1.Plot.Axis(VtChAxisIdY).ValueScale.MajorDivision = 2
   MSChart1.Plot.Axis(VtChAxisIdY).ValueScale.MinorDivision = 1
   For j = 1 To 6
      MSChart1.Plot.SeriesCollection(2 * j - 1).LegendText = "Channel " & j - 1
   Next
 
End Sub

Private Sub UpdateChart(measurement As String)

  ' Open the serial port and flush input buffer
  If (MSComm1.PortOpen = False) Then MSComm1.PortOpen = True
  MSComm1.InputLen = 0
  buffer$ = MSComm1.Input

  'Extract user settings from GUI
  channel = ListChannel.ItemData(ListChannel.ListIndex)
  timescale = ListTimeScale.ItemData(ListTimeScale.ListIndex)
  Mantissa = Int(timescale / 10)
  exponent = timescale Mod 10
  DataPoints = Val(ListPoints.ItemData(ListPoints.ListIndex))
  
  Do  ' loop while "CONT" trigger mode is set
   
     'SEND request for data

     MSComm1.Output = measurement & Chr$(13)
     MSComm1.Output = Str(channel) & Chr$(13)
     MSComm1.Output = Str(Mantissa) & Chr$(13) & Str(exponent) & Chr(13)
     MSComm1.Output = Str(DataPoints) & Chr$(13)
  
     'read data header (if any)
     MSComm1.InputLen = 1
     readHeader

     'declare variable (chartpoints) for analog or digital data
     If measurement = 0 Then
        ReDim chartpoints(1 To DataPoints, 1 To 2) As Double
     Else
        ReDim chartpoints(1 To DataPoints, 1 To 12) As Double
     End If

     ' read data points
     For i = 1 To DataPoints
         Do While MSComm1.InBufferCount < 1
         Loop
         
         Dim str1 As Variant
         str1 = MSComm1.Input

         If measurement = 0 Then
            ' analog data
            chartpoints(i, 1) = i
            chartpoints(i, 2) = Val(str1(0))
         Else
            ' digital data
            Dim j As Byte
            For j = 1 To 6
               chartpoints(i, 2 * j - 1) = i
               inc = (j - 1) / 50
               Dim inByte As Byte
               inByte = str1(0)
               If IsBitSet(inByte, j - 1) = True Then
                  chartpoints(i, 2 * j) = 1 - inc
               Else
                  chartpoints(i, 2 * j) = 0
               End If
            Next
         End If
     Next
     'MSChart1.Plot.Axis(VtChAxisIdX).AxisTitle = "time (" & ListTimeScale.Text & ")"
     MSChart1.ChartData = chartpoints
      
  Loop Until (ListTrigger.ItemData(ListTrigger.ListIndex) = 0)
  'close port
  MSComm1.PortOpen = False  'release com port
End Sub


Private Sub Command3_Click()
  ' Open the serial port and flush input buffer
  If (MSComm1.PortOpen = False) Then MSComm1.PortOpen = True
  MSComm1.InputLen = 0
  buffer$ = MSComm1.Input
  
  'Assemble Digital output parameter
  Dim outByte As Byte
  outByte = 0
  If Check10.Value Then outByte = outByte + Check10.Tag
  If Check11.Value Then outByte = outByte + Check11.Tag
  If Check12.Value Then outByte = outByte + Check12.Tag
  If Check13.Value Then outByte = outByte + Check13.Tag
  If Check14.Value Then outByte = outByte + Check14.Tag
  If Check15.Value Then outByte = outByte + Check15.Tag
  If Check16.Value Then outByte = outByte + Check16.Tag
  If Check17.Value Then outByte = outByte + Check17.Tag

  
  'SEND action request to set digital values
   MSComm1.Output = "2" & Chr$(13)
   MSComm1.Output = Str(outByte) & Chr$(13)
   
   MSComm1.PortOpen = False  'release com port
End Sub

Private Sub Form_Load()
ReDim chartpoints(1 To 100, 1 To 2)

'Make up some pretty data
For i = 1 To 100
   chartpoints(i, 1) = i
   chartpoints(i, 2) = Exp(-i / 30) * (175 * Sin(i)) + 127
Next

'Load into chart1
With MSChart1
  .Visible = True
  .ChartData = chartpoints
  .Plot.UniformAxis = False
End With

'setup default values
ListChannel.ListIndex = 0
ListTimeScale.ListIndex = 2
ListPoints.ListIndex = 1
ListTrigger.ListIndex = 0
MSComm1.InputMode = comInputModeBinary
MSChart1.Plot.SeriesCollection(1).LegendText = "Channel 0"


End Sub

'Read any data that appears before
Private Sub readHeader()
  oldMode = MSComm1.InputMode
  MSComm1.InputMode = comInputModeText
  start = Timer
Do
   Do While MSComm1.InBufferCount < 1
      DoEvents
   Loop
   Char$ = Char$ + MSComm1.Input
Loop Until InStr(Char$, ":")
RichTextBox1.Text = "<" & Char$ & "> : Elapsed time " & Timer - start & RichTextBox1.Text
MSComm1.InputMode = oldMode
End Sub


Private Sub Option4_Click()

End Sub

Private Sub TextYMax_Change()
     MSChart1.Plot.Axis(VtChAxisIdY).ValueScale.Maximum = Val(TextYMax.Text)
End Sub

Private Sub TextYMin_Change()
     MSChart1.Plot.Axis(VtChAxisIdY).ValueScale.Minimum = Val(TextYMin.Text)
End Sub

Public Function IsBitSet(inByte As Byte, Bit As Byte) As Boolean
IsBitSet = ((inByte And (2 ^ Bit)) > 0)
End Function
